#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <list>

#include "UnityNP.h"
#include "Mutex.h"
#include "MessagePipe.h"

DO_EXPORT( bool, PrxHasMessage ) ()
{
	return UnityPlugin::Messages::HasMessage();
}

DO_EXPORT( bool, PrxGetFirstMessage ) (UnityPlugin::Messages::PluginMessage* result)
{
	return UnityPlugin::Messages::GetFirstMessage(result);
}

DO_EXPORT( bool, PrxRemoveFirstMessage ) ()
{
	return UnityPlugin::Messages::RemoveFirstMessage();
}

namespace UnityPlugin
{
	namespace Messages
	{
		std::list<PluginMessage*> messages;
		SimpleLock lockMessages;

		void AddLogMessage(int type, const char* format, ...)
		{
			char buffer[kBufferSize];

			va_list args;
			va_start (args, format);
			vsnprintf_s(buffer,kBufferSize,format, args);
			perror (buffer);
			va_end (args);

			PluginMessage* msg = new PluginMessage();
			msg->type = type;
			msg->SetDataFromString(buffer);
			AddMessage(msg);
		}

		void Log(const char* format, ...)
		{
			char buffer[kBufferSize];
			va_list args;
			va_start (args, format);
#if SONY_PLATFORM
			vsnprintf_s(buffer, kBufferSize, format, args);
#else
			vsnprintf_s(buffer, kBufferSize, _TRUNCATE, format, args);
#endif
			va_end (args);

			PluginMessage* msg = new PluginMessage();
			msg->type = kNPToolKit_Log;
			msg->SetDataFromString(buffer);
			AddMessage(msg);
			UNITY_TRACE(buffer);
		}

		void LogWarning(const char* format, ...)
		{
			char buffer[kBufferSize];
			va_list args;
			va_start (args, format);
			vsnprintf_s(buffer, kBufferSize, format, args);
			va_end (args);

			PluginMessage* msg = new PluginMessage();
			msg->type = kNPToolKit_LogWarning;
			msg->SetDataFromString(buffer);
			AddMessage(msg);
			UNITY_TRACE("WARNING: %s\n", buffer);
		}

		void LogError(const char* format, ...)
		{
			char buffer[kBufferSize];
			va_list args;
			va_start (args, format);
			vsnprintf_s(buffer, kBufferSize, format, args);
			va_end (args);
			
			PluginMessage* msg = new PluginMessage();
			msg->type = kNPToolKit_LogError;
			msg->SetDataFromString(buffer);
			AddMessage(msg);
			UNITY_TRACE("ERROR: %s\n", buffer);
		}

		void AddMessage(MessageType msgType)
		{
			PluginMessage* msg = new UnityPlugin::Messages::PluginMessage();
			msg->type = msgType;
			UnityPlugin::Messages::AddMessage(msg);
		}
	
		void AddMessage(PluginMessage* msg)
		{
			SimpleLock::AutoLock lock(lockMessages);
			messages.push_back(msg);
		}

		bool HasMessage()
		{
			SimpleLock::AutoLock lock(lockMessages);
			return !messages.empty();
		}

		bool GetFirstMessage(PluginMessage* msg)
		{
			SimpleLock::AutoLock lock(lockMessages);
			if(!messages.empty())
			{
				*msg = *messages.front();
				return true;
			}

			return false;
		}

		bool RemoveFirstMessage()
		{
			SimpleLock::AutoLock lock(lockMessages);
			if(!messages.empty())
			{
				delete messages.front();
				messages.pop_front();
				return true;
			}

			return false;
		}

	}
}
